// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Avs
{
    /// <summary>
    /// A class representing a collection of <see cref="AvsCloudLinkResource"/> and their operations.
    /// Each <see cref="AvsCloudLinkResource"/> in the collection will belong to the same instance of <see cref="AvsPrivateCloudResource"/>.
    /// To get an <see cref="AvsCloudLinkCollection"/> instance call the GetAvsCloudLinks method from an instance of <see cref="AvsPrivateCloudResource"/>.
    /// </summary>
    public partial class AvsCloudLinkCollection : ArmCollection, IEnumerable<AvsCloudLinkResource>, IAsyncEnumerable<AvsCloudLinkResource>
    {
        private readonly ClientDiagnostics _avsCloudLinkCloudLinksClientDiagnostics;
        private readonly CloudLinksRestOperations _avsCloudLinkCloudLinksRestClient;

        /// <summary> Initializes a new instance of the <see cref="AvsCloudLinkCollection"/> class for mocking. </summary>
        protected AvsCloudLinkCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="AvsCloudLinkCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal AvsCloudLinkCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _avsCloudLinkCloudLinksClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Avs", AvsCloudLinkResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(AvsCloudLinkResource.ResourceType, out string avsCloudLinkCloudLinksApiVersion);
            _avsCloudLinkCloudLinksRestClient = new CloudLinksRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, avsCloudLinkCloudLinksApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != AvsPrivateCloudResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, AvsPrivateCloudResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create a CloudLink
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/cloudLinks/{cloudLinkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudLinks_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AvsCloudLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cloudLinkName"> Name of the cloud link. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="cloudLinkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="cloudLinkName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<AvsCloudLinkResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string cloudLinkName, AvsCloudLinkData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(cloudLinkName, nameof(cloudLinkName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _avsCloudLinkCloudLinksClientDiagnostics.CreateScope("AvsCloudLinkCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _avsCloudLinkCloudLinksRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cloudLinkName, data, cancellationToken).ConfigureAwait(false);
                var operation = new AvsArmOperation<AvsCloudLinkResource>(new AvsCloudLinkOperationSource(Client), _avsCloudLinkCloudLinksClientDiagnostics, Pipeline, _avsCloudLinkCloudLinksRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cloudLinkName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a CloudLink
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/cloudLinks/{cloudLinkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudLinks_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AvsCloudLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cloudLinkName"> Name of the cloud link. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="cloudLinkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="cloudLinkName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<AvsCloudLinkResource> CreateOrUpdate(WaitUntil waitUntil, string cloudLinkName, AvsCloudLinkData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(cloudLinkName, nameof(cloudLinkName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _avsCloudLinkCloudLinksClientDiagnostics.CreateScope("AvsCloudLinkCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _avsCloudLinkCloudLinksRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cloudLinkName, data, cancellationToken);
                var operation = new AvsArmOperation<AvsCloudLinkResource>(new AvsCloudLinkOperationSource(Client), _avsCloudLinkCloudLinksClientDiagnostics, Pipeline, _avsCloudLinkCloudLinksRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cloudLinkName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a CloudLink
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/cloudLinks/{cloudLinkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudLinks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AvsCloudLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cloudLinkName"> Name of the cloud link. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="cloudLinkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="cloudLinkName"/> is null. </exception>
        public virtual async Task<Response<AvsCloudLinkResource>> GetAsync(string cloudLinkName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(cloudLinkName, nameof(cloudLinkName));

            using var scope = _avsCloudLinkCloudLinksClientDiagnostics.CreateScope("AvsCloudLinkCollection.Get");
            scope.Start();
            try
            {
                var response = await _avsCloudLinkCloudLinksRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cloudLinkName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AvsCloudLinkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a CloudLink
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/cloudLinks/{cloudLinkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudLinks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AvsCloudLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cloudLinkName"> Name of the cloud link. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="cloudLinkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="cloudLinkName"/> is null. </exception>
        public virtual Response<AvsCloudLinkResource> Get(string cloudLinkName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(cloudLinkName, nameof(cloudLinkName));

            using var scope = _avsCloudLinkCloudLinksClientDiagnostics.CreateScope("AvsCloudLinkCollection.Get");
            scope.Start();
            try
            {
                var response = _avsCloudLinkCloudLinksRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cloudLinkName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AvsCloudLinkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List CloudLink resources by PrivateCloud
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/cloudLinks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudLinks_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AvsCloudLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="AvsCloudLinkResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<AvsCloudLinkResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _avsCloudLinkCloudLinksRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _avsCloudLinkCloudLinksRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new AvsCloudLinkResource(Client, AvsCloudLinkData.DeserializeAvsCloudLinkData(e)), _avsCloudLinkCloudLinksClientDiagnostics, Pipeline, "AvsCloudLinkCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List CloudLink resources by PrivateCloud
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/cloudLinks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudLinks_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AvsCloudLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="AvsCloudLinkResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<AvsCloudLinkResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _avsCloudLinkCloudLinksRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _avsCloudLinkCloudLinksRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new AvsCloudLinkResource(Client, AvsCloudLinkData.DeserializeAvsCloudLinkData(e)), _avsCloudLinkCloudLinksClientDiagnostics, Pipeline, "AvsCloudLinkCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/cloudLinks/{cloudLinkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudLinks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AvsCloudLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cloudLinkName"> Name of the cloud link. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="cloudLinkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="cloudLinkName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string cloudLinkName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(cloudLinkName, nameof(cloudLinkName));

            using var scope = _avsCloudLinkCloudLinksClientDiagnostics.CreateScope("AvsCloudLinkCollection.Exists");
            scope.Start();
            try
            {
                var response = await _avsCloudLinkCloudLinksRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cloudLinkName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/cloudLinks/{cloudLinkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudLinks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AvsCloudLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cloudLinkName"> Name of the cloud link. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="cloudLinkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="cloudLinkName"/> is null. </exception>
        public virtual Response<bool> Exists(string cloudLinkName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(cloudLinkName, nameof(cloudLinkName));

            using var scope = _avsCloudLinkCloudLinksClientDiagnostics.CreateScope("AvsCloudLinkCollection.Exists");
            scope.Start();
            try
            {
                var response = _avsCloudLinkCloudLinksRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cloudLinkName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/cloudLinks/{cloudLinkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudLinks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AvsCloudLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cloudLinkName"> Name of the cloud link. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="cloudLinkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="cloudLinkName"/> is null. </exception>
        public virtual async Task<NullableResponse<AvsCloudLinkResource>> GetIfExistsAsync(string cloudLinkName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(cloudLinkName, nameof(cloudLinkName));

            using var scope = _avsCloudLinkCloudLinksClientDiagnostics.CreateScope("AvsCloudLinkCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _avsCloudLinkCloudLinksRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cloudLinkName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<AvsCloudLinkResource>(response.GetRawResponse());
                return Response.FromValue(new AvsCloudLinkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/cloudLinks/{cloudLinkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudLinks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AvsCloudLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cloudLinkName"> Name of the cloud link. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="cloudLinkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="cloudLinkName"/> is null. </exception>
        public virtual NullableResponse<AvsCloudLinkResource> GetIfExists(string cloudLinkName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(cloudLinkName, nameof(cloudLinkName));

            using var scope = _avsCloudLinkCloudLinksClientDiagnostics.CreateScope("AvsCloudLinkCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _avsCloudLinkCloudLinksRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cloudLinkName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<AvsCloudLinkResource>(response.GetRawResponse());
                return Response.FromValue(new AvsCloudLinkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<AvsCloudLinkResource> IEnumerable<AvsCloudLinkResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<AvsCloudLinkResource> IAsyncEnumerable<AvsCloudLinkResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
