// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Avs.Samples
{
    public partial class Sample_WorkloadNetworkGatewayResource
    {
        // WorkloadNetworks_GetGateway
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_WorkloadNetworksGetGateway()
        {
            // Generated from example definition: specification/vmware/resource-manager/Microsoft.AVS/stable/2023-09-01/examples/WorkloadNetworks_GetGateway.json
            // this example is just showing the usage of "WorkloadNetworks_GetGateway" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this WorkloadNetworkGatewayResource created on azure
            // for more information of creating WorkloadNetworkGatewayResource, please refer to the document of WorkloadNetworkGatewayResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "group1";
            string privateCloudName = "cloud1";
            string gatewayId = "gateway1";
            ResourceIdentifier workloadNetworkGatewayResourceId = WorkloadNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateCloudName, gatewayId);
            WorkloadNetworkGatewayResource workloadNetworkGateway = client.GetWorkloadNetworkGatewayResource(workloadNetworkGatewayResourceId);

            // invoke the operation
            WorkloadNetworkGatewayResource result = await workloadNetworkGateway.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            WorkloadNetworkGatewayData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
