// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Net;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Avs.Models;

namespace Azure.ResourceManager.Avs.Samples
{
    public partial class Sample_WorkloadNetworkDnsServiceResource
    {
        // WorkloadNetworks_GetDnsService
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_WorkloadNetworksGetDnsService()
        {
            // Generated from example definition: specification/vmware/resource-manager/Microsoft.AVS/stable/2023-09-01/examples/WorkloadNetworks_GetDnsService.json
            // this example is just showing the usage of "WorkloadNetworks_GetDnsService" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this WorkloadNetworkDnsServiceResource created on azure
            // for more information of creating WorkloadNetworkDnsServiceResource, please refer to the document of WorkloadNetworkDnsServiceResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "group1";
            string privateCloudName = "cloud1";
            string dnsServiceId = "dnsService1";
            ResourceIdentifier workloadNetworkDnsServiceResourceId = WorkloadNetworkDnsServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateCloudName, dnsServiceId);
            WorkloadNetworkDnsServiceResource workloadNetworkDnsService = client.GetWorkloadNetworkDnsServiceResource(workloadNetworkDnsServiceResourceId);

            // invoke the operation
            WorkloadNetworkDnsServiceResource result = await workloadNetworkDnsService.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            WorkloadNetworkDnsServiceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // WorkloadNetworks_UpdateDnsService
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_WorkloadNetworksUpdateDnsService()
        {
            // Generated from example definition: specification/vmware/resource-manager/Microsoft.AVS/stable/2023-09-01/examples/WorkloadNetworks_UpdateDnsService.json
            // this example is just showing the usage of "WorkloadNetworks_UpdateDnsService" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this WorkloadNetworkDnsServiceResource created on azure
            // for more information of creating WorkloadNetworkDnsServiceResource, please refer to the document of WorkloadNetworkDnsServiceResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "group1";
            string privateCloudName = "cloud1";
            string dnsServiceId = "dnsService1";
            ResourceIdentifier workloadNetworkDnsServiceResourceId = WorkloadNetworkDnsServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateCloudName, dnsServiceId);
            WorkloadNetworkDnsServiceResource workloadNetworkDnsService = client.GetWorkloadNetworkDnsServiceResource(workloadNetworkDnsServiceResourceId);

            // invoke the operation
            WorkloadNetworkDnsServiceData data = new WorkloadNetworkDnsServiceData()
            {
                DisplayName = "dnsService1",
                DnsServiceIP = IPAddress.Parse("5.5.5.5"),
                DefaultDnsZone = "defaultDnsZone1",
                FqdnZones =
{
"fqdnZone1"
},
                LogLevel = DnsServiceLogLevel.Info,
                Revision = 1L,
            };
            ArmOperation<WorkloadNetworkDnsServiceResource> lro = await workloadNetworkDnsService.UpdateAsync(WaitUntil.Completed, data);
            WorkloadNetworkDnsServiceResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            WorkloadNetworkDnsServiceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // WorkloadNetworks_DeleteDnsService
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_WorkloadNetworksDeleteDnsService()
        {
            // Generated from example definition: specification/vmware/resource-manager/Microsoft.AVS/stable/2023-09-01/examples/WorkloadNetworks_DeleteDnsService.json
            // this example is just showing the usage of "WorkloadNetworks_DeleteDnsService" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this WorkloadNetworkDnsServiceResource created on azure
            // for more information of creating WorkloadNetworkDnsServiceResource, please refer to the document of WorkloadNetworkDnsServiceResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "group1";
            string privateCloudName = "cloud1";
            string dnsServiceId = "dnsService1";
            ResourceIdentifier workloadNetworkDnsServiceResourceId = WorkloadNetworkDnsServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateCloudName, dnsServiceId);
            WorkloadNetworkDnsServiceResource workloadNetworkDnsService = client.GetWorkloadNetworkDnsServiceResource(workloadNetworkDnsServiceResourceId);

            // invoke the operation
            await workloadNetworkDnsService.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
