// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Avs.Models;

namespace Azure.ResourceManager.Avs.Samples
{
    public partial class Sample_ScriptExecutionResource
    {
        // ScriptExecutions_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ScriptExecutionsGet()
        {
            // Generated from example definition: specification/vmware/resource-manager/Microsoft.AVS/stable/2023-09-01/examples/ScriptExecutions_Get.json
            // this example is just showing the usage of "ScriptExecutions_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ScriptExecutionResource created on azure
            // for more information of creating ScriptExecutionResource, please refer to the document of ScriptExecutionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "group1";
            string privateCloudName = "cloud1";
            string scriptExecutionName = "addSsoServer";
            ResourceIdentifier scriptExecutionResourceId = ScriptExecutionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateCloudName, scriptExecutionName);
            ScriptExecutionResource scriptExecution = client.GetScriptExecutionResource(scriptExecutionResourceId);

            // invoke the operation
            ScriptExecutionResource result = await scriptExecution.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ScriptExecutionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ScriptExecutions_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ScriptExecutionsCreateOrUpdate()
        {
            // Generated from example definition: specification/vmware/resource-manager/Microsoft.AVS/stable/2023-09-01/examples/ScriptExecutions_CreateOrUpdate.json
            // this example is just showing the usage of "ScriptExecutions_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ScriptExecutionResource created on azure
            // for more information of creating ScriptExecutionResource, please refer to the document of ScriptExecutionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "group1";
            string privateCloudName = "cloud1";
            string scriptExecutionName = "addSsoServer";
            ResourceIdentifier scriptExecutionResourceId = ScriptExecutionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateCloudName, scriptExecutionName);
            ScriptExecutionResource scriptExecution = client.GetScriptExecutionResource(scriptExecutionResourceId);

            // invoke the operation
            ScriptExecutionData data = new ScriptExecutionData()
            {
                ScriptCmdletId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/scriptPackages/AVS.PowerCommands@1.0.0/scriptCmdlets/New-SsoExternalIdentitySource"),
                Parameters =
{
new ScriptStringExecutionParameterDetails("DomainName")
{
Value = "placeholderDomain.local",
},new ScriptStringExecutionParameterDetails("BaseUserDN")
{
Value = "DC=placeholder, DC=placeholder",
}
},
                HiddenParameters =
{
new ScriptSecureStringExecutionParameterDetails("Password")
{
SecureValue = "PlaceholderPassword",
}
},
                Timeout = "P0Y0M0DT0H60M60S",
                Retention = "P0Y0M60DT0H60M60S",
            };
            ArmOperation<ScriptExecutionResource> lro = await scriptExecution.UpdateAsync(WaitUntil.Completed, data);
            ScriptExecutionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ScriptExecutionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ScriptExecutions_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ScriptExecutionsDelete()
        {
            // Generated from example definition: specification/vmware/resource-manager/Microsoft.AVS/stable/2023-09-01/examples/ScriptExecutions_Delete.json
            // this example is just showing the usage of "ScriptExecutions_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ScriptExecutionResource created on azure
            // for more information of creating ScriptExecutionResource, please refer to the document of ScriptExecutionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "group1";
            string privateCloudName = "cloud1";
            string scriptExecutionName = "addSsoServer";
            ResourceIdentifier scriptExecutionResourceId = ScriptExecutionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateCloudName, scriptExecutionName);
            ScriptExecutionResource scriptExecution = client.GetScriptExecutionResource(scriptExecutionResourceId);

            // invoke the operation
            await scriptExecution.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // ScriptExecutions_GetExecutionLogs
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetExecutionLogs_ScriptExecutionsGetExecutionLogs()
        {
            // Generated from example definition: specification/vmware/resource-manager/Microsoft.AVS/stable/2023-09-01/examples/ScriptExecutions_GetExecutionLogs.json
            // this example is just showing the usage of "ScriptExecutions_GetExecutionLogs" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ScriptExecutionResource created on azure
            // for more information of creating ScriptExecutionResource, please refer to the document of ScriptExecutionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "group1";
            string privateCloudName = "cloud1";
            string scriptExecutionName = "addSsoServer";
            ResourceIdentifier scriptExecutionResourceId = ScriptExecutionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateCloudName, scriptExecutionName);
            ScriptExecutionResource scriptExecution = client.GetScriptExecutionResource(scriptExecutionResourceId);

            // invoke the operation
            IEnumerable<ScriptOutputStreamType> scriptOutputStreamType = new ScriptOutputStreamType[]
            {
ScriptOutputStreamType.Information,new ScriptOutputStreamType("Warnings"),new ScriptOutputStreamType("Errors"),ScriptOutputStreamType.Output
            };
            ScriptExecutionResource result = await scriptExecution.GetExecutionLogsAsync(scriptOutputStreamType: scriptOutputStreamType);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ScriptExecutionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
