// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Avs.Samples
{
    public partial class Sample_GlobalReachConnectionResource
    {
        // GlobalReachConnections_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GlobalReachConnectionsGet()
        {
            // Generated from example definition: specification/vmware/resource-manager/Microsoft.AVS/stable/2023-09-01/examples/GlobalReachConnections_Get.json
            // this example is just showing the usage of "GlobalReachConnections_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GlobalReachConnectionResource created on azure
            // for more information of creating GlobalReachConnectionResource, please refer to the document of GlobalReachConnectionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "group1";
            string privateCloudName = "cloud1";
            string globalReachConnectionName = "connection1";
            ResourceIdentifier globalReachConnectionResourceId = GlobalReachConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateCloudName, globalReachConnectionName);
            GlobalReachConnectionResource globalReachConnection = client.GetGlobalReachConnectionResource(globalReachConnectionResourceId);

            // invoke the operation
            GlobalReachConnectionResource result = await globalReachConnection.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            GlobalReachConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // GlobalReachConnections_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_GlobalReachConnectionsCreateOrUpdate()
        {
            // Generated from example definition: specification/vmware/resource-manager/Microsoft.AVS/stable/2023-09-01/examples/GlobalReachConnections_CreateOrUpdate.json
            // this example is just showing the usage of "GlobalReachConnections_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GlobalReachConnectionResource created on azure
            // for more information of creating GlobalReachConnectionResource, please refer to the document of GlobalReachConnectionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "group1";
            string privateCloudName = "cloud1";
            string globalReachConnectionName = "connection1";
            ResourceIdentifier globalReachConnectionResourceId = GlobalReachConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateCloudName, globalReachConnectionName);
            GlobalReachConnectionResource globalReachConnection = client.GetGlobalReachConnectionResource(globalReachConnectionResourceId);

            // invoke the operation
            GlobalReachConnectionData data = new GlobalReachConnectionData()
            {
                AuthorizationKey = "01010101-0101-0101-0101-010101010101",
                PeerExpressRouteCircuit = new ResourceIdentifier("/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.Network/expressRouteCircuits/mypeer"),
            };
            ArmOperation<GlobalReachConnectionResource> lro = await globalReachConnection.UpdateAsync(WaitUntil.Completed, data);
            GlobalReachConnectionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            GlobalReachConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // GlobalReachConnections_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_GlobalReachConnectionsDelete()
        {
            // Generated from example definition: specification/vmware/resource-manager/Microsoft.AVS/stable/2023-09-01/examples/GlobalReachConnections_Delete.json
            // this example is just showing the usage of "GlobalReachConnections_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GlobalReachConnectionResource created on azure
            // for more information of creating GlobalReachConnectionResource, please refer to the document of GlobalReachConnectionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "group1";
            string privateCloudName = "cloud1";
            string globalReachConnectionName = "connection1";
            ResourceIdentifier globalReachConnectionResourceId = GlobalReachConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateCloudName, globalReachConnectionName);
            GlobalReachConnectionResource globalReachConnection = client.GetGlobalReachConnectionResource(globalReachConnectionResourceId);

            // invoke the operation
            await globalReachConnection.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
