// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Avs.Samples
{
    public partial class Sample_ExpressRouteAuthorizationResource
    {
        // Authorizations_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_AuthorizationsGet()
        {
            // Generated from example definition: specification/vmware/resource-manager/Microsoft.AVS/stable/2023-09-01/examples/Authorizations_Get.json
            // this example is just showing the usage of "Authorizations_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExpressRouteAuthorizationResource created on azure
            // for more information of creating ExpressRouteAuthorizationResource, please refer to the document of ExpressRouteAuthorizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "group1";
            string privateCloudName = "cloud1";
            string authorizationName = "authorization1";
            ResourceIdentifier expressRouteAuthorizationResourceId = ExpressRouteAuthorizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateCloudName, authorizationName);
            ExpressRouteAuthorizationResource expressRouteAuthorization = client.GetExpressRouteAuthorizationResource(expressRouteAuthorizationResourceId);

            // invoke the operation
            ExpressRouteAuthorizationResource result = await expressRouteAuthorization.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ExpressRouteAuthorizationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Authorizations_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_AuthorizationsCreateOrUpdate()
        {
            // Generated from example definition: specification/vmware/resource-manager/Microsoft.AVS/stable/2023-09-01/examples/Authorizations_CreateOrUpdate.json
            // this example is just showing the usage of "Authorizations_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExpressRouteAuthorizationResource created on azure
            // for more information of creating ExpressRouteAuthorizationResource, please refer to the document of ExpressRouteAuthorizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "group1";
            string privateCloudName = "cloud1";
            string authorizationName = "authorization1";
            ResourceIdentifier expressRouteAuthorizationResourceId = ExpressRouteAuthorizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateCloudName, authorizationName);
            ExpressRouteAuthorizationResource expressRouteAuthorization = client.GetExpressRouteAuthorizationResource(expressRouteAuthorizationResourceId);

            // invoke the operation
            ExpressRouteAuthorizationData data = new ExpressRouteAuthorizationData();
            ArmOperation<ExpressRouteAuthorizationResource> lro = await expressRouteAuthorization.UpdateAsync(WaitUntil.Completed, data);
            ExpressRouteAuthorizationResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ExpressRouteAuthorizationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Authorizations_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_AuthorizationsDelete()
        {
            // Generated from example definition: specification/vmware/resource-manager/Microsoft.AVS/stable/2023-09-01/examples/Authorizations_Delete.json
            // this example is just showing the usage of "Authorizations_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExpressRouteAuthorizationResource created on azure
            // for more information of creating ExpressRouteAuthorizationResource, please refer to the document of ExpressRouteAuthorizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "group1";
            string privateCloudName = "cloud1";
            string authorizationName = "authorization1";
            ResourceIdentifier expressRouteAuthorizationResourceId = ExpressRouteAuthorizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateCloudName, authorizationName);
            ExpressRouteAuthorizationResource expressRouteAuthorization = client.GetExpressRouteAuthorizationResource(expressRouteAuthorizationResourceId);

            // invoke the operation
            await expressRouteAuthorization.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
