// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Avs.Samples
{
    public partial class Sample_AvsCloudLinkResource
    {
        // CloudLinks_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_CloudLinksGet()
        {
            // Generated from example definition: specification/vmware/resource-manager/Microsoft.AVS/stable/2023-09-01/examples/CloudLinks_Get.json
            // this example is just showing the usage of "CloudLinks_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AvsCloudLinkResource created on azure
            // for more information of creating AvsCloudLinkResource, please refer to the document of AvsCloudLinkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "group1";
            string privateCloudName = "cloud1";
            string cloudLinkName = "cloudLink1";
            ResourceIdentifier avsCloudLinkResourceId = AvsCloudLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateCloudName, cloudLinkName);
            AvsCloudLinkResource avsCloudLink = client.GetAvsCloudLinkResource(avsCloudLinkResourceId);

            // invoke the operation
            AvsCloudLinkResource result = await avsCloudLink.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AvsCloudLinkData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // CloudLinks_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CloudLinksCreateOrUpdate()
        {
            // Generated from example definition: specification/vmware/resource-manager/Microsoft.AVS/stable/2023-09-01/examples/CloudLinks_CreateOrUpdate.json
            // this example is just showing the usage of "CloudLinks_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AvsCloudLinkResource created on azure
            // for more information of creating AvsCloudLinkResource, please refer to the document of AvsCloudLinkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "group1";
            string privateCloudName = "cloud1";
            string cloudLinkName = "cloudLink1";
            ResourceIdentifier avsCloudLinkResourceId = AvsCloudLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateCloudName, cloudLinkName);
            AvsCloudLinkResource avsCloudLink = client.GetAvsCloudLinkResource(avsCloudLinkResourceId);

            // invoke the operation
            AvsCloudLinkData data = new AvsCloudLinkData()
            {
                LinkedCloud = new ResourceIdentifier("/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.AVS/privateClouds/cloud2"),
            };
            ArmOperation<AvsCloudLinkResource> lro = await avsCloudLink.UpdateAsync(WaitUntil.Completed, data);
            AvsCloudLinkResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AvsCloudLinkData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // CloudLinks_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_CloudLinksDelete()
        {
            // Generated from example definition: specification/vmware/resource-manager/Microsoft.AVS/stable/2023-09-01/examples/CloudLinks_Delete.json
            // this example is just showing the usage of "CloudLinks_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AvsCloudLinkResource created on azure
            // for more information of creating AvsCloudLinkResource, please refer to the document of AvsCloudLinkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "group1";
            string privateCloudName = "cloud1";
            string cloudLinkName = "cloudLink1";
            ResourceIdentifier avsCloudLinkResourceId = AvsCloudLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateCloudName, cloudLinkName);
            AvsCloudLinkResource avsCloudLink = client.GetAvsCloudLinkResource(avsCloudLinkResourceId);

            // invoke the operation
            await avsCloudLink.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
