// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Update classification included in the software update configuration. A comma separated string with required values. </summary>
    public readonly partial struct WindowsUpdateClassification : IEquatable<WindowsUpdateClassification>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WindowsUpdateClassification"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WindowsUpdateClassification(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnclassifiedValue = "Unclassified";
        private const string CriticalValue = "Critical";
        private const string SecurityValue = "Security";
        private const string UpdateRollupValue = "UpdateRollup";
        private const string FeaturePackValue = "FeaturePack";
        private const string ServicePackValue = "ServicePack";
        private const string DefinitionValue = "Definition";
        private const string ToolsValue = "Tools";
        private const string UpdatesValue = "Updates";

        /// <summary> Unclassified. </summary>
        public static WindowsUpdateClassification Unclassified { get; } = new WindowsUpdateClassification(UnclassifiedValue);
        /// <summary> Critical. </summary>
        public static WindowsUpdateClassification Critical { get; } = new WindowsUpdateClassification(CriticalValue);
        /// <summary> Security. </summary>
        public static WindowsUpdateClassification Security { get; } = new WindowsUpdateClassification(SecurityValue);
        /// <summary> UpdateRollup. </summary>
        public static WindowsUpdateClassification UpdateRollup { get; } = new WindowsUpdateClassification(UpdateRollupValue);
        /// <summary> FeaturePack. </summary>
        public static WindowsUpdateClassification FeaturePack { get; } = new WindowsUpdateClassification(FeaturePackValue);
        /// <summary> ServicePack. </summary>
        public static WindowsUpdateClassification ServicePack { get; } = new WindowsUpdateClassification(ServicePackValue);
        /// <summary> Definition. </summary>
        public static WindowsUpdateClassification Definition { get; } = new WindowsUpdateClassification(DefinitionValue);
        /// <summary> Tools. </summary>
        public static WindowsUpdateClassification Tools { get; } = new WindowsUpdateClassification(ToolsValue);
        /// <summary> Updates. </summary>
        public static WindowsUpdateClassification Updates { get; } = new WindowsUpdateClassification(UpdatesValue);
        /// <summary> Determines if two <see cref="WindowsUpdateClassification"/> values are the same. </summary>
        public static bool operator ==(WindowsUpdateClassification left, WindowsUpdateClassification right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WindowsUpdateClassification"/> values are not the same. </summary>
        public static bool operator !=(WindowsUpdateClassification left, WindowsUpdateClassification right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WindowsUpdateClassification"/>. </summary>
        public static implicit operator WindowsUpdateClassification(string value) => new WindowsUpdateClassification(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WindowsUpdateClassification other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WindowsUpdateClassification other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
