// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> The token type. Must be either PersonalAccessToken or Oauth. </summary>
    public readonly partial struct SourceControlTokenType : IEquatable<SourceControlTokenType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SourceControlTokenType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SourceControlTokenType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PersonalAccessTokenValue = "PersonalAccessToken";
        private const string OAuthValue = "Oauth";

        /// <summary> PersonalAccessToken. </summary>
        public static SourceControlTokenType PersonalAccessToken { get; } = new SourceControlTokenType(PersonalAccessTokenValue);
        /// <summary> Oauth. </summary>
        public static SourceControlTokenType OAuth { get; } = new SourceControlTokenType(OAuthValue);
        /// <summary> Determines if two <see cref="SourceControlTokenType"/> values are the same. </summary>
        public static bool operator ==(SourceControlTokenType left, SourceControlTokenType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SourceControlTokenType"/> values are not the same. </summary>
        public static bool operator !=(SourceControlTokenType left, SourceControlTokenType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SourceControlTokenType"/>. </summary>
        public static implicit operator SourceControlTokenType(string value) => new SourceControlTokenType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SourceControlTokenType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SourceControlTokenType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
