// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> The type of the sync job stream. </summary>
    public readonly partial struct SourceControlStreamType : IEquatable<SourceControlStreamType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SourceControlStreamType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SourceControlStreamType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ErrorValue = "Error";
        private const string OutputValue = "Output";

        /// <summary> Error. </summary>
        public static SourceControlStreamType Error { get; } = new SourceControlStreamType(ErrorValue);
        /// <summary> Output. </summary>
        public static SourceControlStreamType Output { get; } = new SourceControlStreamType(OutputValue);
        /// <summary> Determines if two <see cref="SourceControlStreamType"/> values are the same. </summary>
        public static bool operator ==(SourceControlStreamType left, SourceControlStreamType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SourceControlStreamType"/> values are not the same. </summary>
        public static bool operator !=(SourceControlStreamType left, SourceControlStreamType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SourceControlStreamType"/>. </summary>
        public static implicit operator SourceControlStreamType(string value) => new SourceControlStreamType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SourceControlStreamType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SourceControlStreamType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
