// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Task properties of the software update configuration. </summary>
    public partial class SoftwareUpdateConfigurationTasks
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SoftwareUpdateConfigurationTasks"/>. </summary>
        public SoftwareUpdateConfigurationTasks()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SoftwareUpdateConfigurationTasks"/>. </summary>
        /// <param name="preTask"> Pre task properties. </param>
        /// <param name="postTask"> Post task properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SoftwareUpdateConfigurationTasks(SoftwareUpdateConfigurationTaskProperties preTask, SoftwareUpdateConfigurationTaskProperties postTask, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PreTask = preTask;
            PostTask = postTask;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Pre task properties. </summary>
        public SoftwareUpdateConfigurationTaskProperties PreTask { get; set; }
        /// <summary> Post task properties. </summary>
        public SoftwareUpdateConfigurationTaskProperties PostTask { get; set; }
    }
}
