// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Task properties of the software update configuration. </summary>
    public partial class SoftwareUpdateConfigurationRunTaskProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SoftwareUpdateConfigurationRunTaskProperties"/>. </summary>
        internal SoftwareUpdateConfigurationRunTaskProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SoftwareUpdateConfigurationRunTaskProperties"/>. </summary>
        /// <param name="status"> The status of the task. </param>
        /// <param name="source"> The name of the source of the task. </param>
        /// <param name="jobId"> The job id of the task. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SoftwareUpdateConfigurationRunTaskProperties(string status, string source, Guid? jobId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            Source = source;
            JobId = jobId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The status of the task. </summary>
        public string Status { get; }
        /// <summary> The name of the source of the task. </summary>
        public string Source { get; }
        /// <summary> The job id of the task. </summary>
        public Guid? JobId { get; }
    }
}
