// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Software update configuration Run properties. </summary>
    public partial class SoftwareUpdateConfigurationRun
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SoftwareUpdateConfigurationRun"/>. </summary>
        internal SoftwareUpdateConfigurationRun()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SoftwareUpdateConfigurationRun"/>. </summary>
        /// <param name="name"> Name of the software update configuration run. </param>
        /// <param name="id"> Resource Id of the software update configuration run. </param>
        /// <param name="softwareUpdateConfiguration"> software update configuration triggered this run. </param>
        /// <param name="status"> Status of the software update configuration run. </param>
        /// <param name="configuredDuration"> Configured duration for the software update configuration run. </param>
        /// <param name="osType"> Operating system target of the software update configuration triggered this run. </param>
        /// <param name="startOn"> Start time of the software update configuration run. </param>
        /// <param name="endOn"> End time of the software update configuration run. </param>
        /// <param name="computerCount"> Number of computers in the software update configuration run. </param>
        /// <param name="failedCount"> Number of computers with failed status. </param>
        /// <param name="createdOn"> Creation time of the resource, which only appears in the response. </param>
        /// <param name="createdBy"> CreatedBy property, which only appears in the response. </param>
        /// <param name="lastModifiedOn"> Last time resource was modified, which only appears in the response. </param>
        /// <param name="lastModifiedBy"> LastModifiedBy property, which only appears in the response. </param>
        /// <param name="tasks"> Software update configuration tasks triggered in this run. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SoftwareUpdateConfigurationRun(string name, ResourceIdentifier id, SoftwareUpdateConfigurationNavigation softwareUpdateConfiguration, string status, TimeSpan? configuredDuration, string osType, DateTimeOffset? startOn, DateTimeOffset? endOn, int? computerCount, int? failedCount, DateTimeOffset? createdOn, string createdBy, DateTimeOffset? lastModifiedOn, string lastModifiedBy, SoftwareUpdateConfigurationRunTasks tasks, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Id = id;
            SoftwareUpdateConfiguration = softwareUpdateConfiguration;
            Status = status;
            ConfiguredDuration = configuredDuration;
            OSType = osType;
            StartOn = startOn;
            EndOn = endOn;
            ComputerCount = computerCount;
            FailedCount = failedCount;
            CreatedOn = createdOn;
            CreatedBy = createdBy;
            LastModifiedOn = lastModifiedOn;
            LastModifiedBy = lastModifiedBy;
            Tasks = tasks;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the software update configuration run. </summary>
        public string Name { get; }
        /// <summary> Resource Id of the software update configuration run. </summary>
        public ResourceIdentifier Id { get; }
        /// <summary> software update configuration triggered this run. </summary>
        internal SoftwareUpdateConfigurationNavigation SoftwareUpdateConfiguration { get; }
        /// <summary> Name of the software update configuration triggered the software update configuration run. </summary>
        public string SoftwareUpdateName
        {
            get => SoftwareUpdateConfiguration?.Name;
        }

        /// <summary> Status of the software update configuration run. </summary>
        public string Status { get; }
        /// <summary> Configured duration for the software update configuration run. </summary>
        public TimeSpan? ConfiguredDuration { get; }
        /// <summary> Operating system target of the software update configuration triggered this run. </summary>
        public string OSType { get; }
        /// <summary> Start time of the software update configuration run. </summary>
        public DateTimeOffset? StartOn { get; }
        /// <summary> End time of the software update configuration run. </summary>
        public DateTimeOffset? EndOn { get; }
        /// <summary> Number of computers in the software update configuration run. </summary>
        public int? ComputerCount { get; }
        /// <summary> Number of computers with failed status. </summary>
        public int? FailedCount { get; }
        /// <summary> Creation time of the resource, which only appears in the response. </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> CreatedBy property, which only appears in the response. </summary>
        public string CreatedBy { get; }
        /// <summary> Last time resource was modified, which only appears in the response. </summary>
        public DateTimeOffset? LastModifiedOn { get; }
        /// <summary> LastModifiedBy property, which only appears in the response. </summary>
        public string LastModifiedBy { get; }
        /// <summary> Software update configuration tasks triggered in this run. </summary>
        public SoftwareUpdateConfigurationRunTasks Tasks { get; }
    }
}
