// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Automation.Models
{
    internal static partial class SoftwareUpdateConfigurationOperatingSystemTypeExtensions
    {
        public static string ToSerialString(this SoftwareUpdateConfigurationOperatingSystemType value) => value switch
        {
            SoftwareUpdateConfigurationOperatingSystemType.Windows => "Windows",
            SoftwareUpdateConfigurationOperatingSystemType.Linux => "Linux",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SoftwareUpdateConfigurationOperatingSystemType value.")
        };

        public static SoftwareUpdateConfigurationOperatingSystemType ToSoftwareUpdateConfigurationOperatingSystemType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Windows")) return SoftwareUpdateConfigurationOperatingSystemType.Windows;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Linux")) return SoftwareUpdateConfigurationOperatingSystemType.Linux;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SoftwareUpdateConfigurationOperatingSystemType value.");
        }
    }
}
