// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Gets or sets the state of the runbook. </summary>
    public readonly partial struct RunbookState : IEquatable<RunbookState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RunbookState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RunbookState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NewValue = "New";
        private const string EditValue = "Edit";
        private const string PublishedValue = "Published";

        /// <summary> New. </summary>
        public static RunbookState New { get; } = new RunbookState(NewValue);
        /// <summary> Edit. </summary>
        public static RunbookState Edit { get; } = new RunbookState(EditValue);
        /// <summary> Published. </summary>
        public static RunbookState Published { get; } = new RunbookState(PublishedValue);
        /// <summary> Determines if two <see cref="RunbookState"/> values are the same. </summary>
        public static bool operator ==(RunbookState left, RunbookState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RunbookState"/> values are not the same. </summary>
        public static bool operator !=(RunbookState left, RunbookState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RunbookState"/>. </summary>
        public static implicit operator RunbookState(string value) => new RunbookState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RunbookState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RunbookState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
