// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Gets or sets the provisioning state of the runbook. </summary>
    public readonly partial struct RunbookProvisioningState : IEquatable<RunbookProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RunbookProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RunbookProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";

        /// <summary> Succeeded. </summary>
        public static RunbookProvisioningState Succeeded { get; } = new RunbookProvisioningState(SucceededValue);
        /// <summary> Determines if two <see cref="RunbookProvisioningState"/> values are the same. </summary>
        public static bool operator ==(RunbookProvisioningState left, RunbookProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RunbookProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(RunbookProvisioningState left, RunbookProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RunbookProvisioningState"/>. </summary>
        public static implicit operator RunbookProvisioningState(string value) => new RunbookProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RunbookProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RunbookProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
