// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Definition of the runbook parameter type. </summary>
    public partial class RunbookParameterDefinition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RunbookParameterDefinition"/>. </summary>
        public RunbookParameterDefinition()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RunbookParameterDefinition"/>. </summary>
        /// <param name="runbookParameterType"> Gets or sets the type of the parameter. </param>
        /// <param name="isMandatory"> Gets or sets a Boolean value to indicate whether the parameter is mandatory or not. </param>
        /// <param name="position"> Get or sets the position of the parameter. </param>
        /// <param name="defaultValue"> Gets or sets the default value of parameter. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RunbookParameterDefinition(string runbookParameterType, bool? isMandatory, int? position, string defaultValue, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RunbookParameterType = runbookParameterType;
            IsMandatory = isMandatory;
            Position = position;
            DefaultValue = defaultValue;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the type of the parameter. </summary>
        public string RunbookParameterType { get; set; }
        /// <summary> Gets or sets a Boolean value to indicate whether the parameter is mandatory or not. </summary>
        public bool? IsMandatory { get; set; }
        /// <summary> Get or sets the position of the parameter. </summary>
        public int? Position { get; set; }
        /// <summary> Gets or sets the default value of parameter. </summary>
        public string DefaultValue { get; set; }
    }
}
