// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Raw Graphical Runbook content. </summary>
    public partial class RawGraphicalRunbookContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RawGraphicalRunbookContent"/>. </summary>
        public RawGraphicalRunbookContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RawGraphicalRunbookContent"/>. </summary>
        /// <param name="schemaVersion"> Schema version of the serializer. </param>
        /// <param name="runbookDefinition"> Serialized Graphical runbook. </param>
        /// <param name="runbookType"> Runbook Type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RawGraphicalRunbookContent(string schemaVersion, string runbookDefinition, GraphRunbookType? runbookType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SchemaVersion = schemaVersion;
            RunbookDefinition = runbookDefinition;
            RunbookType = runbookType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Schema version of the serializer. </summary>
        public string SchemaVersion { get; set; }
        /// <summary> Serialized Graphical runbook. </summary>
        public string RunbookDefinition { get; set; }
        /// <summary> Runbook Type. </summary>
        public GraphRunbookType? RunbookType { get; set; }
    }
}
