// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Automation.Models
{
    internal static partial class QueryTagOperatorExtensions
    {
        public static string ToSerialString(this QueryTagOperator value) => value switch
        {
            QueryTagOperator.All => "All",
            QueryTagOperator.Any => "Any",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown QueryTagOperator value.")
        };

        public static QueryTagOperator ToQueryTagOperator(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "All")) return QueryTagOperator.All;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Any")) return QueryTagOperator.Any;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown QueryTagOperator value.");
        }
    }
}
