// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Non Azure query for the update configuration. </summary>
    public partial class NonAzureQueryProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NonAzureQueryProperties"/>. </summary>
        public NonAzureQueryProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NonAzureQueryProperties"/>. </summary>
        /// <param name="functionAlias"> Log Analytics Saved Search name. </param>
        /// <param name="workspaceId"> Workspace Id for Log Analytics in which the saved Search is resided. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NonAzureQueryProperties(string functionAlias, string workspaceId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FunctionAlias = functionAlias;
            WorkspaceId = workspaceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Log Analytics Saved Search name. </summary>
        public string FunctionAlias { get; set; }
        /// <summary> Workspace Id for Log Analytics in which the saved Search is resided. </summary>
        public string WorkspaceId { get; set; }
    }
}
