// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Update classifications included in the software update configuration. </summary>
    public readonly partial struct LinuxUpdateClassification : IEquatable<LinuxUpdateClassification>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LinuxUpdateClassification"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LinuxUpdateClassification(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnclassifiedValue = "Unclassified";
        private const string CriticalValue = "Critical";
        private const string SecurityValue = "Security";
        private const string OtherValue = "Other";

        /// <summary> Unclassified. </summary>
        public static LinuxUpdateClassification Unclassified { get; } = new LinuxUpdateClassification(UnclassifiedValue);
        /// <summary> Critical. </summary>
        public static LinuxUpdateClassification Critical { get; } = new LinuxUpdateClassification(CriticalValue);
        /// <summary> Security. </summary>
        public static LinuxUpdateClassification Security { get; } = new LinuxUpdateClassification(SecurityValue);
        /// <summary> Other. </summary>
        public static LinuxUpdateClassification Other { get; } = new LinuxUpdateClassification(OtherValue);
        /// <summary> Determines if two <see cref="LinuxUpdateClassification"/> values are the same. </summary>
        public static bool operator ==(LinuxUpdateClassification left, LinuxUpdateClassification right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LinuxUpdateClassification"/> values are not the same. </summary>
        public static bool operator !=(LinuxUpdateClassification left, LinuxUpdateClassification right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LinuxUpdateClassification"/>. </summary>
        public static implicit operator LinuxUpdateClassification(string value) => new LinuxUpdateClassification(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LinuxUpdateClassification other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LinuxUpdateClassification other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
