// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Type of the HybridWorker. </summary>
    public readonly partial struct HybridWorkerType : IEquatable<HybridWorkerType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HybridWorkerType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HybridWorkerType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HybridV1Value = "HybridV1";
        private const string HybridV2Value = "HybridV2";

        /// <summary> HybridV1. </summary>
        public static HybridWorkerType HybridV1 { get; } = new HybridWorkerType(HybridV1Value);
        /// <summary> HybridV2. </summary>
        public static HybridWorkerType HybridV2 { get; } = new HybridWorkerType(HybridV2Value);
        /// <summary> Determines if two <see cref="HybridWorkerType"/> values are the same. </summary>
        public static bool operator ==(HybridWorkerType left, HybridWorkerType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HybridWorkerType"/> values are not the same. </summary>
        public static bool operator !=(HybridWorkerType left, HybridWorkerType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HybridWorkerType"/>. </summary>
        public static implicit operator HybridWorkerType(string value) => new HybridWorkerType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HybridWorkerType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HybridWorkerType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
