// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Type of the HybridWorkerGroup. </summary>
    public readonly partial struct HybridWorkerGroup : IEquatable<HybridWorkerGroup>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HybridWorkerGroup"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HybridWorkerGroup(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UserValue = "User";
        private const string SystemValue = "System";

        /// <summary> User. </summary>
        public static HybridWorkerGroup User { get; } = new HybridWorkerGroup(UserValue);
        /// <summary> System. </summary>
        public static HybridWorkerGroup System { get; } = new HybridWorkerGroup(SystemValue);
        /// <summary> Determines if two <see cref="HybridWorkerGroup"/> values are the same. </summary>
        public static bool operator ==(HybridWorkerGroup left, HybridWorkerGroup right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HybridWorkerGroup"/> values are not the same. </summary>
        public static bool operator !=(HybridWorkerGroup left, HybridWorkerGroup right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HybridWorkerGroup"/>. </summary>
        public static implicit operator HybridWorkerGroup(string value) => new HybridWorkerGroup(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HybridWorkerGroup other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HybridWorkerGroup other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
