// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> The parameters supplied to the create hybrid runbook worker group operation. </summary>
    public partial class HybridRunbookWorkerGroupCreateOrUpdateContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HybridRunbookWorkerGroupCreateOrUpdateContent"/>. </summary>
        public HybridRunbookWorkerGroupCreateOrUpdateContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HybridRunbookWorkerGroupCreateOrUpdateContent"/>. </summary>
        /// <param name="name"> Gets or sets the name of the resource. </param>
        /// <param name="credential"> Sets the credential of a worker group. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HybridRunbookWorkerGroupCreateOrUpdateContent(string name, RunAsCredentialAssociationProperty credential, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Credential = credential;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the name of the resource. </summary>
        public string Name { get; set; }
        /// <summary> Sets the credential of a worker group. </summary>
        internal RunAsCredentialAssociationProperty Credential { get; set; }
        /// <summary> Gets or sets the name of the credential. </summary>
        public string CredentialName
        {
            get => Credential is null ? default : Credential.Name;
            set
            {
                if (Credential is null)
                    Credential = new RunAsCredentialAssociationProperty();
                Credential.Name = value;
            }
        }
    }
}
