// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Runbook Type. </summary>
    public readonly partial struct GraphRunbookType : IEquatable<GraphRunbookType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GraphRunbookType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GraphRunbookType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GraphPowerShellValue = "GraphPowerShell";
        private const string GraphPowerShellWorkflowValue = "GraphPowerShellWorkflow";

        /// <summary> GraphPowerShell. </summary>
        public static GraphRunbookType GraphPowerShell { get; } = new GraphRunbookType(GraphPowerShellValue);
        /// <summary> GraphPowerShellWorkflow. </summary>
        public static GraphRunbookType GraphPowerShellWorkflow { get; } = new GraphRunbookType(GraphPowerShellWorkflowValue);
        /// <summary> Determines if two <see cref="GraphRunbookType"/> values are the same. </summary>
        public static bool operator ==(GraphRunbookType left, GraphRunbookType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GraphRunbookType"/> values are not the same. </summary>
        public static bool operator !=(GraphRunbookType left, GraphRunbookType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GraphRunbookType"/>. </summary>
        public static implicit operator GraphRunbookType(string value) => new GraphRunbookType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GraphRunbookType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GraphRunbookType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
