// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Automation.Models
{
    internal static partial class EncryptionKeySourceTypeExtensions
    {
        public static string ToSerialString(this EncryptionKeySourceType value) => value switch
        {
            EncryptionKeySourceType.MicrosoftAutomation => "Microsoft.Automation",
            EncryptionKeySourceType.MicrosoftKeyvault => "Microsoft.Keyvault",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown EncryptionKeySourceType value.")
        };

        public static EncryptionKeySourceType ToEncryptionKeySourceType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Microsoft.Automation")) return EncryptionKeySourceType.MicrosoftAutomation;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Microsoft.Keyvault")) return EncryptionKeySourceType.MicrosoftKeyvault;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown EncryptionKeySourceType value.");
        }
    }
}
