// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Definition of the dsc node report error type. </summary>
    public partial class DscReportError
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DscReportError"/>. </summary>
        internal DscReportError()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DscReportError"/>. </summary>
        /// <param name="errorSource"> Gets or sets the source of the error. </param>
        /// <param name="resourceId"> Gets or sets the resource ID which generated the error. </param>
        /// <param name="errorCode"> Gets or sets the error code. </param>
        /// <param name="errorMessage"> Gets or sets the error message. </param>
        /// <param name="locale"> Gets or sets the locale of the error. </param>
        /// <param name="errorDetails"> Gets or sets the error details. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DscReportError(string errorSource, string resourceId, string errorCode, string errorMessage, string locale, string errorDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ErrorSource = errorSource;
            ResourceId = resourceId;
            ErrorCode = errorCode;
            ErrorMessage = errorMessage;
            Locale = locale;
            ErrorDetails = errorDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the source of the error. </summary>
        public string ErrorSource { get; }
        /// <summary> Gets or sets the resource ID which generated the error. </summary>
        public string ResourceId { get; }
        /// <summary> Gets or sets the error code. </summary>
        public string ErrorCode { get; }
        /// <summary> Gets or sets the error message. </summary>
        public string ErrorMessage { get; }
        /// <summary> Gets or sets the locale of the error. </summary>
        public string Locale { get; }
        /// <summary> Gets or sets the error details. </summary>
        public string ErrorDetails { get; }
    }
}
