// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Definition of the dsc node report type. </summary>
    public partial class DscNodeReport
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DscNodeReport"/>. </summary>
        internal DscNodeReport()
        {
            Errors = new ChangeTrackingList<DscReportError>();
            Resources = new ChangeTrackingList<DscReportResource>();
            IPV4Addresses = new ChangeTrackingList<string>();
            IPV6Addresses = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="DscNodeReport"/>. </summary>
        /// <param name="endOn"> Gets or sets the end time of the node report. </param>
        /// <param name="lastModifiedOn"> Gets or sets the lastModifiedTime of the node report. </param>
        /// <param name="startOn"> Gets or sets the start time of the node report. </param>
        /// <param name="dscNodeReportType"> Gets or sets the type of the node report. </param>
        /// <param name="reportId"> Gets or sets the id of the node report. </param>
        /// <param name="status"> Gets or sets the status of the node report. </param>
        /// <param name="refreshMode"> Gets or sets the refreshMode of the node report. </param>
        /// <param name="rebootRequested"> Gets or sets the rebootRequested of the node report. </param>
        /// <param name="reportFormatVersion"> Gets or sets the reportFormatVersion of the node report. </param>
        /// <param name="configurationVersion"> Gets or sets the configurationVersion of the node report. </param>
        /// <param name="id"> Gets or sets the id. </param>
        /// <param name="errors"> Gets or sets the errors for the node report. </param>
        /// <param name="resources"> Gets or sets the resource for the node report. </param>
        /// <param name="metaConfiguration"> Gets or sets the metaConfiguration of the node at the time of the report. </param>
        /// <param name="hostName"> Gets or sets the hostname of the node that sent the report. </param>
        /// <param name="ipV4Addresses"> Gets or sets the IPv4 address of the node that sent the report. </param>
        /// <param name="ipV6Addresses"> Gets or sets the IPv6 address of the node that sent the report. </param>
        /// <param name="numberOfResources"> Gets or sets the number of resource in the node report. </param>
        /// <param name="rawErrors"> Gets or sets the unparsed errors for the node report. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DscNodeReport(DateTimeOffset? endOn, DateTimeOffset? lastModifiedOn, DateTimeOffset? startOn, string dscNodeReportType, string reportId, string status, string refreshMode, string rebootRequested, string reportFormatVersion, string configurationVersion, string id, IReadOnlyList<DscReportError> errors, IReadOnlyList<DscReportResource> resources, DscMetaConfiguration metaConfiguration, string hostName, IReadOnlyList<string> ipV4Addresses, IReadOnlyList<string> ipV6Addresses, int? numberOfResources, string rawErrors, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EndOn = endOn;
            LastModifiedOn = lastModifiedOn;
            StartOn = startOn;
            DscNodeReportType = dscNodeReportType;
            ReportId = reportId;
            Status = status;
            RefreshMode = refreshMode;
            RebootRequested = rebootRequested;
            ReportFormatVersion = reportFormatVersion;
            ConfigurationVersion = configurationVersion;
            Id = id;
            Errors = errors;
            Resources = resources;
            MetaConfiguration = metaConfiguration;
            HostName = hostName;
            IPV4Addresses = ipV4Addresses;
            IPV6Addresses = ipV6Addresses;
            NumberOfResources = numberOfResources;
            RawErrors = rawErrors;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the end time of the node report. </summary>
        public DateTimeOffset? EndOn { get; }
        /// <summary> Gets or sets the lastModifiedTime of the node report. </summary>
        public DateTimeOffset? LastModifiedOn { get; }
        /// <summary> Gets or sets the start time of the node report. </summary>
        public DateTimeOffset? StartOn { get; }
        /// <summary> Gets or sets the type of the node report. </summary>
        public string DscNodeReportType { get; }
        /// <summary> Gets or sets the id of the node report. </summary>
        public string ReportId { get; }
        /// <summary> Gets or sets the status of the node report. </summary>
        public string Status { get; }
        /// <summary> Gets or sets the refreshMode of the node report. </summary>
        public string RefreshMode { get; }
        /// <summary> Gets or sets the rebootRequested of the node report. </summary>
        public string RebootRequested { get; }
        /// <summary> Gets or sets the reportFormatVersion of the node report. </summary>
        public string ReportFormatVersion { get; }
        /// <summary> Gets or sets the configurationVersion of the node report. </summary>
        public string ConfigurationVersion { get; }
        /// <summary> Gets or sets the id. </summary>
        public string Id { get; }
        /// <summary> Gets or sets the errors for the node report. </summary>
        public IReadOnlyList<DscReportError> Errors { get; }
        /// <summary> Gets or sets the resource for the node report. </summary>
        public IReadOnlyList<DscReportResource> Resources { get; }
        /// <summary> Gets or sets the metaConfiguration of the node at the time of the report. </summary>
        public DscMetaConfiguration MetaConfiguration { get; }
        /// <summary> Gets or sets the hostname of the node that sent the report. </summary>
        public string HostName { get; }
        /// <summary> Gets or sets the IPv4 address of the node that sent the report. </summary>
        public IReadOnlyList<string> IPV4Addresses { get; }
        /// <summary> Gets or sets the IPv6 address of the node that sent the report. </summary>
        public IReadOnlyList<string> IPV6Addresses { get; }
        /// <summary> Gets or sets the number of resource in the node report. </summary>
        public int? NumberOfResources { get; }
        /// <summary> Gets or sets the unparsed errors for the node report. </summary>
        public string RawErrors { get; }
    }
}
