// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> The parameters supplied to the update dsc node operation. </summary>
    public partial class DscNodePatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DscNodePatch"/>. </summary>
        public DscNodePatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DscNodePatch"/>. </summary>
        /// <param name="nodeId"> Gets or sets the id of the dsc node. </param>
        /// <param name="properties"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DscNodePatch(string nodeId, DscNodeUpdateParametersProperties properties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NodeId = nodeId;
            Properties = properties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the id of the dsc node. </summary>
        public string NodeId { get; set; }
        /// <summary> Gets or sets the properties. </summary>
        internal DscNodeUpdateParametersProperties Properties { get; set; }
        /// <summary> Gets or sets the name of the dsc node configuration. </summary>
        public string DscNodeUpdateParametersName
        {
            get => Properties is null ? default : Properties.Name;
            set
            {
                if (Properties is null)
                    Properties = new DscNodeUpdateParametersProperties();
                Properties.Name = value;
            }
        }
    }
}
