// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Gets the count of nodes by count type. </summary>
    internal partial class DscNodeCountListResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DscNodeCountListResult"/>. </summary>
        internal DscNodeCountListResult()
        {
            Value = new ChangeTrackingList<DscNodeCount>();
        }

        /// <summary> Initializes a new instance of <see cref="DscNodeCountListResult"/>. </summary>
        /// <param name="value"> Gets an array of counts. </param>
        /// <param name="totalCount"> Gets the total number of records matching countType criteria. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DscNodeCountListResult(IReadOnlyList<DscNodeCount> value, int? totalCount, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            TotalCount = totalCount;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets an array of counts. </summary>
        public IReadOnlyList<DscNodeCount> Value { get; }
        /// <summary> Gets the total number of records matching countType criteria. </summary>
        public int? TotalCount { get; }
    }
}
