// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> The response model for the list job operation. </summary>
    internal partial class DscNodeConfigurationListResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DscNodeConfigurationListResult"/>. </summary>
        internal DscNodeConfigurationListResult()
        {
            Value = new ChangeTrackingList<DscNodeConfigurationData>();
        }

        /// <summary> Initializes a new instance of <see cref="DscNodeConfigurationListResult"/>. </summary>
        /// <param name="value"> Gets or sets a list of Dsc node configurations. </param>
        /// <param name="nextLink"> Gets or sets the next link. </param>
        /// <param name="totalCount"> Gets or sets the total rows in query. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DscNodeConfigurationListResult(IReadOnlyList<DscNodeConfigurationData> value, string nextLink, int? totalCount, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            NextLink = nextLink;
            TotalCount = totalCount;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets a list of Dsc node configurations. </summary>
        public IReadOnlyList<DscNodeConfigurationData> Value { get; }
        /// <summary> Gets or sets the next link. </summary>
        public string NextLink { get; }
        /// <summary> Gets or sets the total rows in query. </summary>
        public int? TotalCount { get; }
    }
}
