// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Automation.Models
{
    public partial class DscMetaConfiguration : IUtf8JsonSerializable, IJsonModel<DscMetaConfiguration>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DscMetaConfiguration>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DscMetaConfiguration>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DscMetaConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DscMetaConfiguration)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ConfigurationModeFrequencyMins))
            {
                writer.WritePropertyName("configurationModeFrequencyMins"u8);
                writer.WriteNumberValue(ConfigurationModeFrequencyMins.Value);
            }
            if (Optional.IsDefined(RebootNodeIfNeeded))
            {
                writer.WritePropertyName("rebootNodeIfNeeded"u8);
                writer.WriteBooleanValue(RebootNodeIfNeeded.Value);
            }
            if (Optional.IsDefined(ConfigurationMode))
            {
                writer.WritePropertyName("configurationMode"u8);
                writer.WriteStringValue(ConfigurationMode);
            }
            if (Optional.IsDefined(ActionAfterReboot))
            {
                writer.WritePropertyName("actionAfterReboot"u8);
                writer.WriteStringValue(ActionAfterReboot);
            }
            if (Optional.IsDefined(CertificateId))
            {
                writer.WritePropertyName("certificateId"u8);
                writer.WriteStringValue(CertificateId);
            }
            if (Optional.IsDefined(RefreshFrequencyMins))
            {
                writer.WritePropertyName("refreshFrequencyMins"u8);
                writer.WriteNumberValue(RefreshFrequencyMins.Value);
            }
            if (Optional.IsDefined(AllowModuleOverwrite))
            {
                writer.WritePropertyName("allowModuleOverwrite"u8);
                writer.WriteBooleanValue(AllowModuleOverwrite.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DscMetaConfiguration IJsonModel<DscMetaConfiguration>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DscMetaConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DscMetaConfiguration)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDscMetaConfiguration(document.RootElement, options);
        }

        internal static DscMetaConfiguration DeserializeDscMetaConfiguration(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? configurationModeFrequencyMins = default;
            bool? rebootNodeIfNeeded = default;
            string configurationMode = default;
            string actionAfterReboot = default;
            string certificateId = default;
            int? refreshFrequencyMins = default;
            bool? allowModuleOverwrite = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("configurationModeFrequencyMins"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    configurationModeFrequencyMins = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("rebootNodeIfNeeded"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    rebootNodeIfNeeded = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("configurationMode"u8))
                {
                    configurationMode = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("actionAfterReboot"u8))
                {
                    actionAfterReboot = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("certificateId"u8))
                {
                    certificateId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("refreshFrequencyMins"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    refreshFrequencyMins = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("allowModuleOverwrite"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    allowModuleOverwrite = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DscMetaConfiguration(
                configurationModeFrequencyMins,
                rebootNodeIfNeeded,
                configurationMode,
                actionAfterReboot,
                certificateId,
                refreshFrequencyMins,
                allowModuleOverwrite,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DscMetaConfiguration>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DscMetaConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DscMetaConfiguration)} does not support writing '{options.Format}' format.");
            }
        }

        DscMetaConfiguration IPersistableModel<DscMetaConfiguration>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DscMetaConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDscMetaConfiguration(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DscMetaConfiguration)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DscMetaConfiguration>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
