// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Gets or sets the state of the configuration. </summary>
    public readonly partial struct DscConfigurationState : IEquatable<DscConfigurationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DscConfigurationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DscConfigurationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NewValue = "New";
        private const string EditValue = "Edit";
        private const string PublishedValue = "Published";

        /// <summary> New. </summary>
        public static DscConfigurationState New { get; } = new DscConfigurationState(NewValue);
        /// <summary> Edit. </summary>
        public static DscConfigurationState Edit { get; } = new DscConfigurationState(EditValue);
        /// <summary> Published. </summary>
        public static DscConfigurationState Published { get; } = new DscConfigurationState(PublishedValue);
        /// <summary> Determines if two <see cref="DscConfigurationState"/> values are the same. </summary>
        public static bool operator ==(DscConfigurationState left, DscConfigurationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DscConfigurationState"/> values are not the same. </summary>
        public static bool operator !=(DscConfigurationState left, DscConfigurationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DscConfigurationState"/>. </summary>
        public static implicit operator DscConfigurationState(string value) => new DscConfigurationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DscConfigurationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DscConfigurationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
