// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Gets or sets the provisioning state of the configuration. </summary>
    public readonly partial struct DscConfigurationProvisioningState : IEquatable<DscConfigurationProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DscConfigurationProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DscConfigurationProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";

        /// <summary> Succeeded. </summary>
        public static DscConfigurationProvisioningState Succeeded { get; } = new DscConfigurationProvisioningState(SucceededValue);
        /// <summary> Determines if two <see cref="DscConfigurationProvisioningState"/> values are the same. </summary>
        public static bool operator ==(DscConfigurationProvisioningState left, DscConfigurationProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DscConfigurationProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(DscConfigurationProvisioningState left, DscConfigurationProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DscConfigurationProvisioningState"/>. </summary>
        public static implicit operator DscConfigurationProvisioningState(string value) => new DscConfigurationProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DscConfigurationProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DscConfigurationProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
