// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Azure query for the update configuration. </summary>
    public partial class AzureQueryProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AzureQueryProperties"/>. </summary>
        public AzureQueryProperties()
        {
            Scope = new ChangeTrackingList<string>();
            Locations = new ChangeTrackingList<AzureLocation>();
        }

        /// <summary> Initializes a new instance of <see cref="AzureQueryProperties"/>. </summary>
        /// <param name="scope"> List of Subscription or Resource Group ARM Ids. </param>
        /// <param name="locations"> List of locations to scope the query to. </param>
        /// <param name="tagSettings"> Tag settings for the VM. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AzureQueryProperties(IList<string> scope, IList<AzureLocation> locations, QueryTagSettingsProperties tagSettings, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Scope = scope;
            Locations = locations;
            TagSettings = tagSettings;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of Subscription or Resource Group ARM Ids. </summary>
        public IList<string> Scope { get; }
        /// <summary> List of locations to scope the query to. </summary>
        public IList<AzureLocation> Locations { get; }
        /// <summary> Tag settings for the VM. </summary>
        public QueryTagSettingsProperties TagSettings { get; set; }
    }
}
