// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Definition of Usage. </summary>
    public partial class AutomationUsage
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutomationUsage"/>. </summary>
        internal AutomationUsage()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AutomationUsage"/>. </summary>
        /// <param name="id"> Gets or sets the id of the resource. </param>
        /// <param name="name"> Gets or sets the usage counter name. </param>
        /// <param name="unit"> Gets or sets the usage unit name. </param>
        /// <param name="currentValue"> Gets or sets the current usage value. </param>
        /// <param name="limit"> Gets or sets max limit. -1 for unlimited. </param>
        /// <param name="throttleStatus"> Gets or sets the throttle status. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutomationUsage(string id, AutomationUsageCounterName name, string unit, double? currentValue, long? limit, string throttleStatus, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Name = name;
            Unit = unit;
            CurrentValue = currentValue;
            Limit = limit;
            ThrottleStatus = throttleStatus;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the id of the resource. </summary>
        public string Id { get; }
        /// <summary> Gets or sets the usage counter name. </summary>
        public AutomationUsageCounterName Name { get; }
        /// <summary> Gets or sets the usage unit name. </summary>
        public string Unit { get; }
        /// <summary> Gets or sets the current usage value. </summary>
        public double? CurrentValue { get; }
        /// <summary> Gets or sets max limit. -1 for unlimited. </summary>
        public long? Limit { get; }
        /// <summary> Gets or sets the throttle status. </summary>
        public string ThrottleStatus { get; }
    }
}
