// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> The AutomationRunbookDraft. </summary>
    public partial class AutomationRunbookDraft
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutomationRunbookDraft"/>. </summary>
        public AutomationRunbookDraft()
        {
            Parameters = new ChangeTrackingDictionary<string, RunbookParameterDefinition>();
            OutputTypes = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AutomationRunbookDraft"/>. </summary>
        /// <param name="isInEditMode"> Gets or sets whether runbook is in edit mode. </param>
        /// <param name="draftContentLink"> Gets or sets the draft runbook content link. </param>
        /// <param name="createdOn"> Gets or sets the creation time of the runbook draft. </param>
        /// <param name="lastModifiedOn"> Gets or sets the last modified time of the runbook draft. </param>
        /// <param name="parameters"> Gets or sets the runbook draft parameters. </param>
        /// <param name="outputTypes"> Gets or sets the runbook output types. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutomationRunbookDraft(bool? isInEditMode, AutomationContentLink draftContentLink, DateTimeOffset? createdOn, DateTimeOffset? lastModifiedOn, IDictionary<string, RunbookParameterDefinition> parameters, IList<string> outputTypes, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsInEditMode = isInEditMode;
            DraftContentLink = draftContentLink;
            CreatedOn = createdOn;
            LastModifiedOn = lastModifiedOn;
            Parameters = parameters;
            OutputTypes = outputTypes;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets whether runbook is in edit mode. </summary>
        public bool? IsInEditMode { get; set; }
        /// <summary> Gets or sets the draft runbook content link. </summary>
        public AutomationContentLink DraftContentLink { get; set; }
        /// <summary> Gets or sets the creation time of the runbook draft. </summary>
        public DateTimeOffset? CreatedOn { get; set; }
        /// <summary> Gets or sets the last modified time of the runbook draft. </summary>
        public DateTimeOffset? LastModifiedOn { get; set; }
        /// <summary> Gets or sets the runbook draft parameters. </summary>
        public IDictionary<string, RunbookParameterDefinition> Parameters { get; }
        /// <summary> Gets or sets the runbook output types. </summary>
        public IList<string> OutputTypes { get; }
    }
}
