// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Automation key permissions. </summary>
    public readonly partial struct AutomationKeyPermission : IEquatable<AutomationKeyPermission>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AutomationKeyPermission"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AutomationKeyPermission(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ReadValue = "Read";
        private const string FullValue = "Full";

        /// <summary> Read. </summary>
        public static AutomationKeyPermission Read { get; } = new AutomationKeyPermission(ReadValue);
        /// <summary> Full. </summary>
        public static AutomationKeyPermission Full { get; } = new AutomationKeyPermission(FullValue);
        /// <summary> Determines if two <see cref="AutomationKeyPermission"/> values are the same. </summary>
        public static bool operator ==(AutomationKeyPermission left, AutomationKeyPermission right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AutomationKeyPermission"/> values are not the same. </summary>
        public static bool operator !=(AutomationKeyPermission left, AutomationKeyPermission right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AutomationKeyPermission"/>. </summary>
        public static implicit operator AutomationKeyPermission(string value) => new AutomationKeyPermission(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AutomationKeyPermission other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AutomationKeyPermission other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
