// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Automation key which is used to register a DSC Node. </summary>
    public partial class AutomationKey
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutomationKey"/>. </summary>
        internal AutomationKey()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AutomationKey"/>. </summary>
        /// <param name="keyName"> Automation key name. </param>
        /// <param name="permissions"> Automation key permissions. </param>
        /// <param name="value"> Value of the Automation Key used for registration. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutomationKey(AutomationKeyName? keyName, AutomationKeyPermission? permissions, string value, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyName = keyName;
            Permissions = permissions;
            Value = value;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Automation key name. </summary>
        public AutomationKeyName? KeyName { get; }
        /// <summary> Automation key permissions. </summary>
        public AutomationKeyPermission? Permissions { get; }
        /// <summary> Value of the Automation Key used for registration. </summary>
        public string Value { get; }
    }
}
