// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Definition of the job stream. </summary>
    public partial class AutomationJobStream
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutomationJobStream"/>. </summary>
        internal AutomationJobStream()
        {
            Value = new ChangeTrackingDictionary<string, BinaryData>();
        }

        /// <summary> Initializes a new instance of <see cref="AutomationJobStream"/>. </summary>
        /// <param name="id"> Gets or sets the id of the resource. </param>
        /// <param name="jobStreamId"> Gets or sets the id of the job stream. </param>
        /// <param name="time"> Gets or sets the creation time of the job. </param>
        /// <param name="streamType"> Gets or sets the stream type. </param>
        /// <param name="streamText"> Gets or sets the stream text. </param>
        /// <param name="summary"> Gets or sets the summary. </param>
        /// <param name="value"> Gets or sets the values of the job stream. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutomationJobStream(ResourceIdentifier id, string jobStreamId, DateTimeOffset? time, AutomationJobStreamType? streamType, string streamText, string summary, IReadOnlyDictionary<string, BinaryData> value, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            JobStreamId = jobStreamId;
            Time = time;
            StreamType = streamType;
            StreamText = streamText;
            Summary = summary;
            Value = value;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the id of the resource. </summary>
        public ResourceIdentifier Id { get; }
        /// <summary> Gets or sets the id of the job stream. </summary>
        public string JobStreamId { get; }
        /// <summary> Gets or sets the creation time of the job. </summary>
        public DateTimeOffset? Time { get; }
        /// <summary> Gets or sets the stream type. </summary>
        public AutomationJobStreamType? StreamType { get; }
        /// <summary> Gets or sets the stream text. </summary>
        public string StreamText { get; }
        /// <summary> Gets or sets the summary. </summary>
        public string Summary { get; }
        /// <summary>
        /// Gets or sets the values of the job stream.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IReadOnlyDictionary<string, BinaryData> Value { get; }
    }
}
