// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> The AutomationCountType. </summary>
    public readonly partial struct AutomationCountType : IEquatable<AutomationCountType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AutomationCountType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AutomationCountType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StatusValue = "status";
        private const string NodeConfigurationValue = "nodeconfiguration";

        /// <summary> status. </summary>
        public static AutomationCountType Status { get; } = new AutomationCountType(StatusValue);
        /// <summary> nodeconfiguration. </summary>
        public static AutomationCountType NodeConfiguration { get; } = new AutomationCountType(NodeConfigurationValue);
        /// <summary> Determines if two <see cref="AutomationCountType"/> values are the same. </summary>
        public static bool operator ==(AutomationCountType left, AutomationCountType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AutomationCountType"/> values are not the same. </summary>
        public static bool operator !=(AutomationCountType left, AutomationCountType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AutomationCountType"/>. </summary>
        public static implicit operator AutomationCountType(string value) => new AutomationCountType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AutomationCountType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AutomationCountType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
