// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Gets or sets the content source type. </summary>
    public readonly partial struct AutomationContentSourceType : IEquatable<AutomationContentSourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AutomationContentSourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AutomationContentSourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EmbeddedContentValue = "embeddedContent";
        private const string UriValue = "uri";

        /// <summary> embeddedContent. </summary>
        public static AutomationContentSourceType EmbeddedContent { get; } = new AutomationContentSourceType(EmbeddedContentValue);
        /// <summary> uri. </summary>
        public static AutomationContentSourceType Uri { get; } = new AutomationContentSourceType(UriValue);
        /// <summary> Determines if two <see cref="AutomationContentSourceType"/> values are the same. </summary>
        public static bool operator ==(AutomationContentSourceType left, AutomationContentSourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AutomationContentSourceType"/> values are not the same. </summary>
        public static bool operator !=(AutomationContentSourceType left, AutomationContentSourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AutomationContentSourceType"/>. </summary>
        public static implicit operator AutomationContentSourceType(string value) => new AutomationContentSourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AutomationContentSourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AutomationContentSourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
