// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> The parameters supplied to the regenerate keys operation. </summary>
    public partial class AgentRegistrationRegenerateKeyContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AgentRegistrationRegenerateKeyContent"/>. </summary>
        /// <param name="keyName"> Gets or sets the agent registration key name - primary or secondary. </param>
        public AgentRegistrationRegenerateKeyContent(AgentRegistrationKeyName keyName)
        {
            KeyName = keyName;
        }

        /// <summary> Initializes a new instance of <see cref="AgentRegistrationRegenerateKeyContent"/>. </summary>
        /// <param name="keyName"> Gets or sets the agent registration key name - primary or secondary. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AgentRegistrationRegenerateKeyContent(AgentRegistrationKeyName keyName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyName = keyName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AgentRegistrationRegenerateKeyContent"/> for deserialization. </summary>
        internal AgentRegistrationRegenerateKeyContent()
        {
        }

        /// <summary> Gets or sets the agent registration key name - primary or secondary. </summary>
        public AgentRegistrationKeyName KeyName { get; }
    }
}
