// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Automation.Models
{
    /// <summary> Gets or sets the agent registration key name - primary or secondary. </summary>
    public readonly partial struct AgentRegistrationKeyName : IEquatable<AgentRegistrationKeyName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AgentRegistrationKeyName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AgentRegistrationKeyName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PrimaryValue = "primary";
        private const string SecondaryValue = "secondary";

        /// <summary> primary. </summary>
        public static AgentRegistrationKeyName Primary { get; } = new AgentRegistrationKeyName(PrimaryValue);
        /// <summary> secondary. </summary>
        public static AgentRegistrationKeyName Secondary { get; } = new AgentRegistrationKeyName(SecondaryValue);
        /// <summary> Determines if two <see cref="AgentRegistrationKeyName"/> values are the same. </summary>
        public static bool operator ==(AgentRegistrationKeyName left, AgentRegistrationKeyName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AgentRegistrationKeyName"/> values are not the same. </summary>
        public static bool operator !=(AgentRegistrationKeyName left, AgentRegistrationKeyName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AgentRegistrationKeyName"/>. </summary>
        public static implicit operator AgentRegistrationKeyName(string value) => new AgentRegistrationKeyName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AgentRegistrationKeyName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AgentRegistrationKeyName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
