// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.IO;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Automation
{
    internal class StreamOperationSource : IOperationSource<Stream>
    {
        Stream IOperationSource<Stream>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return BinaryData.FromString(document.RootElement.GetRawText()).ToStream();
        }

        async ValueTask<Stream> IOperationSource<Stream>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return BinaryData.FromString(document.RootElement.GetRawText()).ToStream();
        }
    }
}
