// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Automation
{
    internal class DscCompilationJobOperationSource : IOperationSource<DscCompilationJobResource>
    {
        private readonly ArmClient _client;

        internal DscCompilationJobOperationSource(ArmClient client)
        {
            _client = client;
        }

        DscCompilationJobResource IOperationSource<DscCompilationJobResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DscCompilationJobData.DeserializeDscCompilationJobData(document.RootElement);
            return new DscCompilationJobResource(_client, data);
        }

        async ValueTask<DscCompilationJobResource> IOperationSource<DscCompilationJobResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DscCompilationJobData.DeserializeDscCompilationJobData(document.RootElement);
            return new DscCompilationJobResource(_client, data);
        }
    }
}
