// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Automation
{
    internal class AutomationPrivateEndpointConnectionOperationSource : IOperationSource<AutomationPrivateEndpointConnectionResource>
    {
        private readonly ArmClient _client;

        internal AutomationPrivateEndpointConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        AutomationPrivateEndpointConnectionResource IOperationSource<AutomationPrivateEndpointConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AutomationPrivateEndpointConnectionData.DeserializeAutomationPrivateEndpointConnectionData(document.RootElement);
            return new AutomationPrivateEndpointConnectionResource(_client, data);
        }

        async ValueTask<AutomationPrivateEndpointConnectionResource> IOperationSource<AutomationPrivateEndpointConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AutomationPrivateEndpointConnectionData.DeserializeAutomationPrivateEndpointConnectionData(document.RootElement);
            return new AutomationPrivateEndpointConnectionResource(_client, data);
        }
    }
}
