// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Automation.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Automation
{
    /// <summary>
    /// A class representing the DscNode data model.
    /// Definition of a DscNode
    /// </summary>
    public partial class DscNodeData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DscNodeData"/>. </summary>
        public DscNodeData()
        {
            ExtensionHandler = new ChangeTrackingList<DscNodeExtensionHandlerAssociationProperty>();
        }

        /// <summary> Initializes a new instance of <see cref="DscNodeData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="lastSeenOn"> Gets or sets the last seen time of the node. </param>
        /// <param name="registrationOn"> Gets or sets the registration time of the node. </param>
        /// <param name="ip"> Gets or sets the ip of the node. </param>
        /// <param name="accountId"> Gets or sets the account id of the node. </param>
        /// <param name="status"> Gets or sets the status of the node. </param>
        /// <param name="nodeId"> Gets or sets the node id. </param>
        /// <param name="etag"> Gets or sets the etag of the resource. </param>
        /// <param name="totalCount"> Gets the total number of records matching filter criteria. </param>
        /// <param name="extensionHandler"> Gets or sets the list of extensionHandler properties for a Node. </param>
        /// <param name="namePropertiesNodeConfigurationName"> Gets or sets the name of the dsc node configuration. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DscNodeData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DateTimeOffset? lastSeenOn, DateTimeOffset? registrationOn, string ip, string accountId, string status, string nodeId, ETag? etag, int? totalCount, IList<DscNodeExtensionHandlerAssociationProperty> extensionHandler, string namePropertiesNodeConfigurationName, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            LastSeenOn = lastSeenOn;
            RegistrationOn = registrationOn;
            IP = ip;
            AccountId = accountId;
            Status = status;
            NodeId = nodeId;
            ETag = etag;
            TotalCount = totalCount;
            ExtensionHandler = extensionHandler;
            NamePropertiesNodeConfigurationName = namePropertiesNodeConfigurationName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the last seen time of the node. </summary>
        public DateTimeOffset? LastSeenOn { get; set; }
        /// <summary> Gets or sets the registration time of the node. </summary>
        public DateTimeOffset? RegistrationOn { get; set; }
        /// <summary> Gets or sets the ip of the node. </summary>
        public string IP { get; set; }
        /// <summary> Gets or sets the account id of the node. </summary>
        public string AccountId { get; set; }
        /// <summary> Gets or sets the status of the node. </summary>
        public string Status { get; set; }
        /// <summary> Gets or sets the node id. </summary>
        public string NodeId { get; set; }
        /// <summary> Gets or sets the etag of the resource. </summary>
        public ETag? ETag { get; set; }
        /// <summary> Gets the total number of records matching filter criteria. </summary>
        public int? TotalCount { get; set; }
        /// <summary> Gets or sets the list of extensionHandler properties for a Node. </summary>
        public IList<DscNodeExtensionHandlerAssociationProperty> ExtensionHandler { get; }
        /// <summary> Gets or sets the name of the dsc node configuration. </summary>
        public string NamePropertiesNodeConfigurationName { get; set; }
    }
}
