// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Automation
{
    /// <summary>
    /// A class representing the AutomationWatcher data model.
    /// Definition of the watcher type.
    /// </summary>
    public partial class AutomationWatcherData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutomationWatcherData"/>. </summary>
        /// <param name="location"> The location. </param>
        public AutomationWatcherData(AzureLocation location) : base(location)
        {
            ScriptParameters = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="AutomationWatcherData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"> Gets or sets the etag of the resource. </param>
        /// <param name="executionFrequencyInSeconds"> Gets or sets the frequency at which the watcher is invoked. </param>
        /// <param name="scriptName"> Gets or sets the name of the script the watcher is attached to, i.e. the name of an existing runbook. </param>
        /// <param name="scriptParameters"> Gets or sets the parameters of the script. </param>
        /// <param name="scriptRunOn"> Gets or sets the name of the hybrid worker group the watcher will run on. </param>
        /// <param name="status"> Gets the current status of the watcher. </param>
        /// <param name="createdOn"> Gets or sets the creation time. </param>
        /// <param name="lastModifiedOn"> Gets or sets the last modified time. </param>
        /// <param name="lastModifiedBy"> Details of the user who last modified the watcher. </param>
        /// <param name="description"> Gets or sets the description. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutomationWatcherData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ETag? etag, long? executionFrequencyInSeconds, string scriptName, IDictionary<string, string> scriptParameters, string scriptRunOn, string status, DateTimeOffset? createdOn, DateTimeOffset? lastModifiedOn, string lastModifiedBy, string description, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            ETag = etag;
            ExecutionFrequencyInSeconds = executionFrequencyInSeconds;
            ScriptName = scriptName;
            ScriptParameters = scriptParameters;
            ScriptRunOn = scriptRunOn;
            Status = status;
            CreatedOn = createdOn;
            LastModifiedOn = lastModifiedOn;
            LastModifiedBy = lastModifiedBy;
            Description = description;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AutomationWatcherData"/> for deserialization. </summary>
        internal AutomationWatcherData()
        {
        }

        /// <summary> Gets or sets the etag of the resource. </summary>
        public ETag? ETag { get; set; }
        /// <summary> Gets or sets the frequency at which the watcher is invoked. </summary>
        public long? ExecutionFrequencyInSeconds { get; set; }
        /// <summary> Gets or sets the name of the script the watcher is attached to, i.e. the name of an existing runbook. </summary>
        public string ScriptName { get; set; }
        /// <summary> Gets or sets the parameters of the script. </summary>
        public IDictionary<string, string> ScriptParameters { get; }
        /// <summary> Gets or sets the name of the hybrid worker group the watcher will run on. </summary>
        public string ScriptRunOn { get; set; }
        /// <summary> Gets the current status of the watcher. </summary>
        public string Status { get; }
        /// <summary> Gets or sets the creation time. </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> Gets or sets the last modified time. </summary>
        public DateTimeOffset? LastModifiedOn { get; }
        /// <summary> Details of the user who last modified the watcher. </summary>
        public string LastModifiedBy { get; }
        /// <summary> Gets or sets the description. </summary>
        public string Description { get; set; }
    }
}
