// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Automation.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Automation
{
    /// <summary>
    /// A class representing the AutomationJob data model.
    /// Definition of the job.
    /// </summary>
    public partial class AutomationJobData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutomationJobData"/>. </summary>
        public AutomationJobData()
        {
            Parameters = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="AutomationJobData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="runbook"> Gets or sets the runbook. </param>
        /// <param name="startedBy"> Gets or sets the job started by. </param>
        /// <param name="runOn"> Gets or sets the runOn which specifies the group name where the job is to be executed. </param>
        /// <param name="jobId"> Gets or sets the id of the job. </param>
        /// <param name="createdOn"> Gets or sets the creation time of the job. </param>
        /// <param name="status"> Gets or sets the status of the job. </param>
        /// <param name="statusDetails"> Gets or sets the status details of the job. </param>
        /// <param name="startOn"> Gets or sets the start time of the job. </param>
        /// <param name="endOn"> Gets or sets the end time of the job. </param>
        /// <param name="exception"> Gets or sets the exception of the job. </param>
        /// <param name="lastModifiedOn"> Gets or sets the last modified time of the job. </param>
        /// <param name="lastStatusModifiedOn"> Gets or sets the last status modified time of the job. </param>
        /// <param name="parameters"> Gets or sets the parameters of the job. </param>
        /// <param name="provisioningState"> The current provisioning state of the job. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutomationJobData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, RunbookAssociationProperty runbook, string startedBy, string runOn, Guid? jobId, DateTimeOffset? createdOn, AutomationJobStatus? status, string statusDetails, DateTimeOffset? startOn, DateTimeOffset? endOn, string exception, DateTimeOffset? lastModifiedOn, DateTimeOffset? lastStatusModifiedOn, IDictionary<string, string> parameters, JobProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Runbook = runbook;
            StartedBy = startedBy;
            RunOn = runOn;
            JobId = jobId;
            CreatedOn = createdOn;
            Status = status;
            StatusDetails = statusDetails;
            StartOn = startOn;
            EndOn = endOn;
            Exception = exception;
            LastModifiedOn = lastModifiedOn;
            LastStatusModifiedOn = lastStatusModifiedOn;
            Parameters = parameters;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the runbook. </summary>
        internal RunbookAssociationProperty Runbook { get; set; }
        /// <summary> Gets or sets the name of the runbook. </summary>
        public string RunbookName
        {
            get => Runbook is null ? default : Runbook.Name;
            set
            {
                if (Runbook is null)
                    Runbook = new RunbookAssociationProperty();
                Runbook.Name = value;
            }
        }

        /// <summary> Gets or sets the job started by. </summary>
        public string StartedBy { get; set; }
        /// <summary> Gets or sets the runOn which specifies the group name where the job is to be executed. </summary>
        public string RunOn { get; set; }
        /// <summary> Gets or sets the id of the job. </summary>
        public Guid? JobId { get; set; }
        /// <summary> Gets or sets the creation time of the job. </summary>
        public DateTimeOffset? CreatedOn { get; set; }
        /// <summary> Gets or sets the status of the job. </summary>
        public AutomationJobStatus? Status { get; set; }
        /// <summary> Gets or sets the status details of the job. </summary>
        public string StatusDetails { get; set; }
        /// <summary> Gets or sets the start time of the job. </summary>
        public DateTimeOffset? StartOn { get; set; }
        /// <summary> Gets or sets the end time of the job. </summary>
        public DateTimeOffset? EndOn { get; set; }
        /// <summary> Gets or sets the exception of the job. </summary>
        public string Exception { get; set; }
        /// <summary> Gets or sets the last modified time of the job. </summary>
        public DateTimeOffset? LastModifiedOn { get; set; }
        /// <summary> Gets or sets the last status modified time of the job. </summary>
        public DateTimeOffset? LastStatusModifiedOn { get; set; }
        /// <summary> Gets or sets the parameters of the job. </summary>
        public IDictionary<string, string> Parameters { get; }
        /// <summary> The current provisioning state of the job. </summary>
        public JobProvisioningState? ProvisioningState { get; set; }
    }
}
